/*---------------------------------------------------------------------------*\

    FILE....: GenericWin32.cpp
    TYPE....: C Functions
    AUTHOR..: David Rowe
    DATE....: 6/9/01

    Win32 implementation of Generic functions.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <windows.h>
#include <process.h>

#include "generic.h"
//#include "hipplx.h"

void WINAPI GenericInitializeCriticalSection(GENERIC_CRITICAL_SECTION *cs) {
	CRITICAL_SECTION *crit;

	crit = new CRITICAL_SECTION;
	assert(crit != NULL);
	InitializeCriticalSection(crit);
	cs->v = crit;
}

void WINAPI GenericDeleteCriticalSection(GENERIC_CRITICAL_SECTION *cs) {
	CRITICAL_SECTION *crit = (CRITICAL_SECTION*)cs->v;
	DeleteCriticalSection(crit);
	delete crit;
}

void WINAPI GenericEnterCriticalSection(GENERIC_CRITICAL_SECTION *cs)  {
	CRITICAL_SECTION *crit = (CRITICAL_SECTION*)cs->v;
	EnterCriticalSection(crit);
}

void WINAPI GenericLeaveCriticalSection(GENERIC_CRITICAL_SECTION *cs)  {
	CRITICAL_SECTION *crit = (CRITICAL_SECTION*)cs->v;
	LeaveCriticalSection(crit);
}

int GenericGetOS()
{
	return GET_OS_WINDOWS_NT;
}

unsigned long GenerictimeGetTime() {
	return timeGetTime();
}

void GenericSleep(unsigned int ms) {
	Sleep(ms);
}

int GenericDeviceIoControl(
	void	      *hndFile,	      // Handle to device
	long	      IoctlCode,      // IO Control code for Read
	void	      *InBuffer,      // Buffer to driver.
	long	      InBufferSize,      
	void	      *OutBuffer,     // Buffer from driver
	long	      OutBufferSize,     
	unsigned long *BytesReturned, // no. bytes returned from driver
	void	      *Overlapped     
)
{
	return 0;
}

void WINAPI Generic_beginthread(void(*func)(void*), int stack, void *data)
{
	_beginthread(func, stack, data);
}

void WINAPI Generic_endthread() 
{
	_endthread();
}

void GenericSetThreadPriorityHigh() {
	HANDLE h = GetCurrentThread();
	assert(SetThreadPriority(h,THREAD_PRIORITY_TIME_CRITICAL)==TRUE);
}
void GenericSetThreadPriorityNormal() {
	HANDLE h = GetCurrentThread();
	assert(SetThreadPriority(h,THREAD_PRIORITY_NORMAL)==TRUE);
}

int hipplx_GetNumCards();  // hdr for function in hipplx.cpp

int GenericGetNumCards(int vpb_model) {
	assert(vpb_model == VPB_V4PCI);
	// all plx-specifc code in hipplx.cpp
	return hipplx_GetNumCards();
}

int GenericGetCardType() {
	return VPB_V4PCI;
}


